%This program is used to compute the ATS for AR(1) cases by using CUSUM.
%u0,s0 are the mean function and variance function estimated from IC data.
%u,s are the speicified mean function and variance function.
%k is the reference value
%h is the control limit
%phi is the coefficients of AR(1) model
%m out of n is the sampling rate
function [ats,count]=ATS_Dtime(u0,s0,u,s,k,h,phi,m,n)
L=length(u0);
for i=1:ceil(L/n)
    A=randperm(n);
    B(((i-1)*m+1):((i-1)*m+m))=(i-1)*n+sort(A(1:m));
end
% B(1)=1;
B(ceil(L/n)*m+1)=L+1;
T=B(1);
x(B(1))=u(T)+s(T)*normrnd(0,1/sqrt(1-phi^2));
for i=1:(B(2)-B(1))
x(B(1)+i)=u(B(1)+i)+s(B(1)+i)*(phi*(x(B(1)+i-1)-u0(B(1)+i-1))/s0(B(1)+i-1)+normrnd(0,1));
end
count=2;
T=B(count);
e(1)=((x(T)-u0(T))/s0(T)-phi^(B(2)-B(1))*(x(B(1))-u0(B(1)))/s0(B(1)))/sqrt(((1-phi^(2*(B(2)-B(1)))))/(1-phi^2));
Cn=max(0,e(1)-k);
while (Cn<=h && T<=length(u0))
    T=B(count+1);
if T>=L+1
    ats=T;
    break
else
 for i=1:(B(count+1)-B(count))
x(B(count)+i)=u(B(count)+i)+s(B(count)+i)*(phi*(x(B(count)+i-1)-u0(B(count)+i-1))/s0(B(count)+i-1)+normrnd(0,1));
 end
e(count)=((x(T)-u0(T))/s0(T)-phi^(B(count+1)-B(count))*(x(B(count))-u0(B(count)))/s0(B(count)))/sqrt(((1-phi^(2*(B(count+1)-B(count)))))/(1-phi^2));
count=count+1;
Cn=max(0,Cn+e(count-1)-k);
end
end
if T>=L+1
    ats=T;
else
ats=T-B(1);
end